# 画面設計書 15-WasmBrowser（ASP.NET Core統合）

## 概要

本ドキュメントは、ASP.NET Coreと統合されたWasmブラウザクライアント画面の設計書です。この画面は、ASP.NET CoreサーバーにホストされるWebAssemblyクライアントとしてSignalR通信をテストするためのアセットです。

### 本画面の処理概要

この画面では、ASP.NET CoreサーバーにホストされたWebAssemblyクライアントが、SignalRを使用してサーバーと通信するテストを実行します。URLとhrefを引数としてMain関数に渡し、SignalRTestクラスを通じてリアルタイム通信機能を検証します。

**業務上の目的・背景**：本画面は、ASP.NET CoreとWebAssemblyの統合テストを目的としています。SignalRを使用したリアルタイム通信は、チャットやライブ更新機能など多くのWebアプリケーションで必要とされます。このテストアセットは、WebAssemblyクライアントからSignalRハブへの接続と通信が正常に動作することを検証します。WasmEnableThreads設定によりマルチスレッド環境での動作も確認できます。

**画面へのアクセス方法**：ASP.NET Coreサーバーを起動後、`/wasmclient/`パスにアクセスすることで画面が表示されます。サーバー側でstaticWebAssetBasePathが設定されているため、このパスで提供されます。

**主要な操作・処理内容**：
1. ページロード時にWebAssemblyランタイムを初期化
2. window.location.originとhrefを引数としてMain関数を呼び出し
3. SignalRTestクラスのRun()メソッドを実行
4. SignalRハブとの通信テストを実行
5. 結果に応じて終了コードを返す

**画面遷移**：この画面は単一画面テストアプリケーションのため、他画面への遷移はありません。

**権限による表示制御**：認証・権限機能は実装されていません。テスト用アセットのため、すべての機能が実行可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | ASP.NET Core上でのWebAssemblyランタイム実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 34 | Microsoft.Extensions.Hosting | 補助機能 | ASP.NET Core汎用ホスト機能との統合 |
| 13 | System.Net.Http | 補助機能 | ASP.NET CoreサーバーとのHTTP通信 |

## 画面種別

テスト実行画面（ASP.NET Core統合テスト）

## URL/ルーティング

- パス: `/wasmclient/index.html` または `/wasmclient/`
- テンプレートファイル: `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/index.html`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| origin | 入力（URL） | string | window.location.originから取得 |
| href | 入力（URL） | string | window.location.hrefから取得 |

## 表示項目

| 項目名 | 説明 | 初期値 |
|--------|------|--------|
| タイトル | h3要素でアプリケーション名を表示 | WasmBrowser |

## イベント仕様

### 1-ページロード時のSignalRテスト実行

**トリガー**: ページロード完了後、main.jsモジュールが実行される

**処理フロー**:
1. dotnetモジュールをインポート
2. dotnet.withConfig()で設定を適用（appendElementOnExit, exitOnUnhandledError, logExitCode）
3. dotnet.create()でランタイムを初期化
4. getConfig()で設定情報を取得
5. window.location.originとhrefを取得
6. runMainAndExit()でMain関数を実行（引数にorigin, hrefを渡す）
7. SignalRTestが実行され、結果に応じて終了

**結果**: SignalRテストの結果がコンソールに出力される

## データベース更新仕様

本画面ではデータベース操作は行いません。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| コンソール出力 | Main関数実行時 | "arg0: {origin}, arg1: {href}" |
| 例外 | 引数不足時 | "Expected url origin and href passed as arguments" |
| 例外 | テスト失敗時 | "WasmBrowser finished with non-success code: {result}" |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| 引数が2つ未満 | "Expected url origin and href passed as arguments"例外をスロー |
| SignalRテスト失敗（非0の戻り値） | "WasmBrowser finished with non-success code"例外をスロー |
| JavaScript例外発生 | exit(2)でエラー終了 |

## 備考

- 本画面はASP.NET Core上でホストされるWebAssemblyクライアントのテスト用アセットです
- WasmEnableThreadsが有効化されており、マルチスレッド環境で動作します
- Sharedプロジェクトを参照してSignalRTest機能を使用します
- StaticWebAssetBasePathが"wasmclient"に設定されているため、`/wasmclient/`パスで提供されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SignalRTest クラスとその動作を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/Program.cs` | Main関数の引数処理とSignalRTestの呼び出し |

**読解のコツ**: Main関数は2つの引数（origin, fullUrl）を必要とし、これらはJavaScriptから渡されます。

#### Step 2: エントリーポイントを理解する

JavaScriptエントリーポイントの処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.js | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/main.js` | URL情報の取得とrunMainAndExitへの引数渡し |

**主要処理フロー**:
1. **4行目**: dotnetとexit関数をインポート
2. **7-9行目**: dotnet.withConfig()で設定を適用
3. **10行目**: getConfig()で設定取得
4. **11行目**: window.locationからURLを構築
5. **12行目**: runMainAndExit()でMain関数を実行（引数にurl, hrefを渡す）
6. **15-16行目**: try-catch でエラー時にexit(2)

#### Step 3: C#のMain関数を理解する

Main関数とSignalRTestの連携を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/Program.cs` | 引数チェックとSignalRTest.Run()の呼び出し |

**主要処理フロー**:
- **10行目**: `public static async Task Main(string[] args)`で非同期エントリーポイント
- **12-13行目**: 引数が2つ未満の場合は例外スロー
- **15行目**: SignalRTestインスタンスを作成
- **16行目**: 引数をコンソール出力
- **17行目**: SignalRTest.Run()を実行
- **18-19行目**: 非0の結果で例外スロー

#### Step 4: プロジェクト設定を理解する

ASP.NET Core統合の設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WasmBrowserClient.csproj | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/WasmBrowserClient.csproj` | WasmEnableThreadsとStaticWebAssetBasePath設定 |

**主要処理フロー**:
- **11行目**: `<WasmEnableThreads>true</WasmEnableThreads>`でスレッド有効化
- **12行目**: `<StaticWebAssetBasePath>wasmclient</StaticWebAssetBasePath>`で配信パス設定

### プログラム呼び出し階層図

```
main.js (エントリーポイント)
    │
    ├─ dotnet.withConfig()
    │      └─ appendElementOnExit, exitOnUnhandledError, logExitCode設定
    │
    ├─ dotnet.create()
    │      └─ WebAssemblyランタイム初期化
    │
    ├─ window.location
    │      ├─ origin: サーバーオリジン
    │      └─ href: 完全URL
    │
    └─ runMainAndExit(mainAssemblyName, [url, href])
           │
           └─ Program.Main(args) [C#]
                  │
                  ├─ 引数チェック (args.Length < 2 → Exception)
                  │
                  ├─ SignalRTest test = new()
                  │
                  ├─ Console.WriteLine("arg0: ..., arg1: ...")
                  │
                  └─ test.Run(origin, fullUrl)
                         │
                         └─ SignalRハブ通信テスト
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ブラウザURL              JavaScript                     コンソール
location.origin ───▶    main.js                   ───▶    console.log
location.href               │
                            ▼
                    runMainAndExit(args)
                            │
                            ▼
                    Program.Main() [C#]
                            │
                            ▼
                    SignalRTest.Run()
                            │
                            ▼
                    SignalRハブ通信
                            │
                            ▼
                    テスト結果（終了コード）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/index.html` | テンプレート | シンプルなHTML構造 |
| main.js | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/main.js` | ソース | JavaScriptエントリーポイント |
| Program.cs | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/Program.cs` | ソース | C#のMain関数、SignalRTest呼び出し |
| TestOutput.cs | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/TestOutput.cs` | ソース | テスト出力用ヘルパークラス |
| WasmBrowserClient.csproj | `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/WasmBrowserClient.csproj` | 設定 | プロジェクト設定（スレッド有効化） |
